import { system, world, BlockPermutation } from '@minecraft/server';

function chrysalis_grow(e) {
	if (Math.random() < 0.75) {
		return;
	}
		
	const block = e.block;
	const growthStage = block?.permutation.getState("sf_nba:growth_stage");
	const direction = block?.permutation.getState("minecraft:block_face");
	
	if (growthStage == 2) {
		block.dimension.spawnEntity("sf_nba:butterfly", block.location);
		block.setPermutation(BlockPermutation.resolve("minecraft:air"));
	}
	else {
		block.setPermutation(BlockPermutation.resolve(`sf_nba:chrysalis_block`, { "minecraft:block_face": direction, "sf_nba:growth_stage": growthStage + 1 }));
	}
}

function chrysalis_update(e) {
	const block = e.block;
	const direction = block?.permutation.getState("minecraft:block_face");
	
	if (block?.permutation.matches((`sf_nba:chrysalis_stage0`)))
		block.setPermutation(BlockPermutation.resolve(`sf_nba:chrysalis_block`, { "minecraft:block_face": direction, "sf_nba:growth_stage": 0 }));
	else if (block?.permutation.matches((`sf_nba:chrysalis_stage1`)))
		block.setPermutation(BlockPermutation.resolve(`sf_nba:chrysalis_block`, { "minecraft:block_face": direction, "sf_nba:growth_stage": 1 }));
	else if (block?.permutation.matches((`sf_nba:chrysalis_stage2`)))
		block.setPermutation(BlockPermutation.resolve(`sf_nba:chrysalis_block`, { "minecraft:block_face": direction, "sf_nba:growth_stage": 2 }));
}

function check_legacy_chrysalis_list() {
	if (world.getDynamicProperty("sf_nba:chrysalisRegistry") != null)
		world.setDynamicProperty("sf_nba:chrysalisRegistry");
}
system.run(check_legacy_chrysalis_list);

/*
	A best practice is create a class with this methods and bind it.
	We are using Register.js for this to make codes more simple
	and redeable. See item/Fat.js for a binded class example.

	@see - https://learn.microsoft.com/en-us/minecraft/creator/documents/customcomponents?view=minecraft-bedrock-stable
*/
export { chrysalis_grow, chrysalis_update }